/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.connectivity;

import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.tasks.connectivity.ChangeModemConfig;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.util.LocalizableText;
import java.io.Serializable;
import java.util.List;

public class ConnectivityState
implements Serializable {
    private static final String TRACE_MASKD = "JIWZCOSD";
    private static final String TRACE_MASKF = "JIWZCOSF";
    private static final String TRACE_MASKT = "JIWZCOST";
    private int activePanelIndex = -1;
    private String[] activePanelNameStack;
    ChangeModemConfig modemConfigData;
    private boolean modemConfigChanged = false;
    private LocalizableText licenseAgreement;
    private boolean dialUpSelected = false;
    private boolean internetSelected = false;
    private boolean passThruSelected = false;
    private boolean licenseAgreementAccepted = false;
    private boolean warningShown = false;
    private boolean initialSelection = true;
    List passThruInfo = null;
    List dialUpInfo = null;

    public ConnectivityState(OutboundConfigData outboundConfigData, ChangeModemConfig changeModemConfig, LocalizableText localizableText) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "--> ConnectivityState()");
        }
        this.activePanelNameStack = new String[5];
        ++this.activePanelIndex;
        this.activePanelNameStack[this.activePanelIndex] = "ConnectivityMainPanel";
        boolean bl = false;
        if (outboundConfigData.isCallHomeServer()) {
            this.dialUpSelected = outboundConfigData.isAllowDial();
            this.internetSelected = outboundConfigData.isAllowInternet();
            this.passThruSelected = outboundConfigData.isAllowPassthru();
        }
        this.modemConfigData = changeModemConfig;
        this.licenseAgreement = localizableText;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-- ConnectivityState()");
        }
    }

    public static void main(String[] stringArray) {
    }

    public void saveMainState(String[] stringArray) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->saveMainState()");
        }
        this.dialUpSelected = false;
        this.internetSelected = false;
        this.passThruSelected = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (Trace.LEVEL >= 1) {
                Trace.trace(TRACE_MASKT, "i = " + i + " item: " + stringArray[i]);
            }
            if (stringArray[i].trim().endsWith("DialupGroup")) {
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "   saveMainState() - dialup");
                }
                this.dialUpSelected = true;
            }
            if (stringArray[i].trim().endsWith("VPNGroup")) {
                if (Trace.LEVEL >= 3) {
                    Trace.trace(TRACE_MASKD, "   saveMainState() - VPN");
                }
                this.internetSelected = true;
            }
            if (!stringArray[i].trim().endsWith("PassThruGroup")) continue;
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "   saveMainState() - passthru");
            }
            this.passThruSelected = true;
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--saveMainState()");
        }
    }

    public void saveDialUpState(ChangeModemConfig changeModemConfig, List list) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->saveDialUpState()");
        }
        this.modemConfigData = changeModemConfig;
        this.dialUpInfo = list;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--saveDialUpState()");
        }
    }

    public List getDialUpInfo() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getDialUpInfo()");
        }
        return this.dialUpInfo;
    }

    public ChangeModemConfig getModemConfigData() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getModemConfigData()");
        }
        return this.modemConfigData;
    }

    public void savePassThruState(List list) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->savePassThruState()");
        }
        this.passThruInfo = list;
    }

    public List getPassThruInfo() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getPassThruInfo()");
        }
        return this.passThruInfo;
    }

    public void pushActivePanelName(String string) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->pushActivePanelName(" + string + ")");
        }
        ++this.activePanelIndex;
        this.activePanelNameStack[this.activePanelIndex] = string;
    }

    public String popActivePanelName() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->popActivePanelName() = " + this.activePanelNameStack[this.activePanelIndex]);
        }
        --this.activePanelIndex;
        return this.activePanelNameStack[this.activePanelIndex + 1];
    }

    public String getActivePanelName() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getActivePanelName() = " + this.activePanelNameStack[this.activePanelIndex]);
        }
        return this.activePanelNameStack[this.activePanelIndex];
    }

    public boolean getDialUpPanelChecked() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getDialUpPanelChecked()");
        }
        return this.dialUpSelected;
    }

    public boolean getVPNPanelChecked() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getVPNPanelChecked()");
        }
        return this.internetSelected;
    }

    public boolean getPassThruPanelChecked() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getPassThruPanelChecked()");
        }
        return this.passThruSelected;
    }

    public boolean getLicenseAgreementAccepted() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getLicenseAgreementAccepted()");
        }
        return this.licenseAgreementAccepted;
    }

    public void setLicenseAgreementAccepted() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setLicenseAgreementAccepted()");
        }
        this.licenseAgreementAccepted = true;
    }

    public LocalizableText getLicenseAgreement() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getLicenseAgreement()");
        }
        return this.licenseAgreement;
    }

    public boolean getWarningShown() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getWarningShown()");
        }
        return this.warningShown;
    }

    public void setWarningShown() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setWarningShown()");
        }
        this.warningShown = true;
    }

    public boolean isInitialSelection() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->isInitialSelection()");
        }
        return this.initialSelection;
    }

    public void clearInitialSelection() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->clearInitialSelection()");
        }
        this.initialSelection = false;
    }

    public boolean hasModemConfigChanged() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->hasModemConfigChanged()");
        }
        return this.modemConfigChanged;
    }

    public void modemConfigHasChanged() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->modemConfigHasChanged()");
        }
        this.modemConfigChanged = true;
    }
}

